#include "stdafx.h"
#include "Utility.h"
#include "stdio.h"
#include "tchar.h"


CUtility::CUtility()
{
}

CUtility::~CUtility()
{
}

std::string CUtility::DataToString(BYTE* pData, UINT nSize, BOOL bSeparator)
{
	std::string strRet = "";
	if((pData != NULL) && (nSize > 0))
	{
		CHAR szData[MAX_PATH];
		for(UINT nCount = 0; nCount < nSize; nCount++)
		{

#ifdef WINCE
			sprintf(szData, "%02X", pData[nCount]);
#else
			sprintf_s(szData, MAX_PATH, "%02X", pData[nCount]);
#endif
			strRet += szData;
			if(bSeparator && (nCount != (nSize - 1)))
			{
				strRet += "-";
			}
		}
	}
	return strRet;
}

EERROR CUtility::SetDataByte(BYTE* pSrc, DWORD dwSrc, BYTE* pDest, DWORD& dwDestLen)
{
	EERROR eRet = ER_INVALID_POINTER;
	if((pSrc != NULL) && (pDest != NULL))
	{
		ZeroMemory(pDest, dwDestLen);
		DWORD dwTotalData = dwSrc <= dwDestLen ? dwSrc : dwDestLen;
		memcpy_s(pDest, dwDestLen, pSrc, dwTotalData);
		eRet = dwTotalData <= dwDestLen ? ER_OK : ER_MORE_DATA;
		dwDestLen = dwTotalData;
	}
	return eRet;
}

void CUtility::HexToByte(BYTE* pDataIn, UINT nSize, BYTE** pData, DWORD& dwSize)
{
	std::string strRet = "";
	if((pDataIn != NULL) && (nSize > 0))
	{
		dwSize = nSize / 2;
		*pData = new BYTE[dwSize];
		UINT nData = -1;
		char szDataConv[3] = {0, 0, 0};
		for(UINT nCount = 0; nCount < nSize / 2; nCount++)
		{
			szDataConv[0x00] = pDataIn[nCount * 2];
			szDataConv[0x01] = pDataIn[nCount * 2 + 1];

#ifdef WINCE
			sscanf(szDataConv, "%02X", &nData);
#else
			sscanf_s(szDataConv, "%02X", &nData);
#endif

			(*pData)[nCount] = nData;
		}
	}
}


